***** Is Europe an optimal Political Area?                *****
***** Alberto Alesina, Guido Tabellini & Francesco Trebbi *****

***** Section VI

*Set up 
clear all
set mem 10g
set matsize 11000
set more off
version 13

use "data/EVS_GSS_final.dta", clear

cap mkdir "appendix"

* EU countries excluding Eastern Europe, no Germany split - We exclude US from this analysis as we want to compute distances only for EU countries
keep if country=="AT"| country=="BE"| country=="DE"| country=="DK"| country=="ES"| country=="FI"| country=="FR"| country=="GR"| country=="IE"| country=="IT"| country=="LU"| country=="NL"| country=="NO"| country=="PT"| country=="SE"| country=="GB-GBN" 

** Setting waves
gen wave=.
replace wave=1 if year==1981 | year==1982 | year==1983 | year==1984 | year==1986
replace wave=2 if year==1990 | year==1991 | year==1993
replace wave=3 if year==1998 | year==1999 | year==2000
replace wave=4 if year==2006 | year==2008 | year==2009 | year==2010 
drop if wave==.

replace country="GB" if country=="GB-GBN"
keep country wave country_pride2
collapse country_pride2, by(wave country)
encode country, g(ccode)
xtset ccode wave
reshape wide country_pride2, i(country) j(wave)

export excel using "appendix/table_a9.xls", replace first(var)
